<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Record') }}
        </h2>
    </x-slot>

    <div class="py-12">
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        .vid {
            width: 500px;
            height: 400px;
            border: 2px solid black;
            position: relative;
            overflow: hidden;
            margin-left: 20px;
        }

        video {
            margin-left: 20px;
            width: 100%;
            height: 100%;
            object-fit: contain;
        }
        #but{
            margin-left: 20px;
        }
    </style>
</head>
<body>
    <div class="vid">
        <video id="vid"></video>
    </div>
    <br>
    <div style="display: flex;width:200px;">
    <button id="but">
        Open WebCam
    </button>
    <button id="record" disabled>
        Record
    </button>
    <button id="stop" disabled>
        Stop Recording
    </button>
    </div>
    <script>
    let video = document.getElementById("vid");
    let but = document.getElementById("but");
    let recordButton = document.getElementById("record");
    let stopButton = document.getElementById("stop");
    let mediaRecorder;
    let recordedChunks = [];
    let isMobile = /iPhone|iPad|iPod|Android/i.test(navigator.userAgent);

    const enableButtons = () => {
        but.disabled = true;
        recordButton.disabled = false;
        stopButton.disabled = true;
    };

    const disableButtons = () => {
        but.disabled = false;
        recordButton.disabled = true;
        stopButton.disabled = false;
    };

    const startRecording = (stream) => {
        recordedChunks = [];
        mediaRecorder = new MediaRecorder(stream);

        mediaRecorder.ondataavailable = (event) => {
            if (event.data.size > 0) {
                recordedChunks.push(event.data);
            }
        };

        mediaRecorder.onstop = () => {
            const blob = new Blob(recordedChunks, { type: 'video/webm' });
            saveVideoToServer(blob); // Send the recorded video to the server
            enableButtons();
        };

        mediaRecorder.start();
        disableButtons();
    };

    const stopRecording = () => {
        mediaRecorder.stop();
    };

    const saveVideoToServer = (videoBlob) => {
        const formData = new FormData();
        const fileName = getFileNameWithDateTime('recorded_video', '.mp4');
        formData.append('video', videoBlob, fileName);
  
        fetch(window.location.href, {
            method: 'POST',
            body: formData,
        })
        .then((response) => response.text())
        .then((result) => {
            console.log(result);
        })
        .catch((error) => {
            console.error('Error saving video on the server:', error);
        });
    };

    const getFileNameWithDateTime = (name, extension) => {
        const now = new Date();
        const datePart = now.toISOString().slice(0, 10);
        const timePart = now.toISOString().slice(11, 19).replace(/:/g, '-');
        return `${name}_${datePart}_${timePart}${extension}`;
    };
    but.addEventListener("click", () => {
        if (isMobile) {
            // Trigger user interaction on mobile devices to request camera access
            document.documentElement.addEventListener('touchstart', () => {
                navigator.mediaDevices
                    .getUserMedia({ video: true, audio: true })
                    .then((stream) => {
                        video.srcObject = stream;
                        window.stream = stream;
                        video.addEventListener("loadedmetadata", () => {
                            video.play();
                        });
                        enableButtons();
                    })
                    .catch((error) => console.error('Error accessing the camera:', error));
            }, { once: true });
        } else {
            navigator.mediaDevices
                .getUserMedia({ video: true, audio: true })
                .then((stream) => {
                    video.srcObject = stream;
                    window.stream = stream;
                    video.addEventListener("loadedmetadata", () => {
                        video.play();
                    });
                    enableButtons();
                })
                .catch((error) => console.error('Error accessing the camera:', error));
        }
    });

    recordButton.addEventListener("click", () => {
        startRecording(window.stream);
    });

    stopButton.addEventListener("click", () => {
        stopRecording();
    });
</script>
  <?php include "upload.php"; ?>

</body>
</html>
</x-app-layout>